<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fo="http://www.w3.org/1999/XSL/Format"
  xpath-default-namespace="http://www.docuteam.ch/xmlns/submAgr">
  <xsl:output method="xml" encoding="UTF-8" indent="yes"/>
  <xsl:strip-space elements="*"/>
  <xsl:template match="/">
    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format"
      xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
      <fo:layout-master-set>
        <fo:simple-page-master master-name="Deckblatt">
          <fo:region-body margin-top="5cm" margin-bottom="2cm" margin-left="3cm" margin-right="2cm"
          />
        </fo:simple-page-master>
        <fo:simple-page-master master-name="Folgeseite">
          <fo:region-body margin="2cm" margin-left="3cm"/>
        </fo:simple-page-master>
        <fo:page-sequence-master master-name="Submission Agreement">
          <fo:single-page-master-reference master-reference="Deckblatt"/>
          <fo:repeatable-page-master-reference master-reference="Folgeseite"/>
        </fo:page-sequence-master>
      </fo:layout-master-set>
      <fo:page-sequence master-reference="Submission Agreement">
        <fo:flow flow-name="xsl-region-body" font-size="10pt" page-break-before="always">
          <fo:block space-before.minimum="12pt" space-before.conditionality="discard"
            space-after="6pt" font-size="14pt" font-weight="bold">Ablieferungsvereinbarung:
              <xsl:value-of select="submAgr/@title"/> (<xsl:value-of select="submAgr/@saID"/>)</fo:block>
          <fo:block space-before.minimum="12pt" space-before.conditionality="discard"
            space-after="6pt" font-size="12pt" font-weight="bold">Akteure</fo:block>
          <fo:table table-layout="fixed" width="16cm" space-after="6pt">
            <fo:table-column border-end-color="black" border-end-style="solid"
              border-end-width="1pt" column-width="2.4cm"/>
            <fo:table-column column-width="6.8cm" number-columns-repeated="2"/>
            <fo:table-header font-weight="bold" width="16cm" border="1pt" border-color="black">
              <fo:table-row border-after-style="solid" border-after-color="black"
                border-after-width="1pt">
                <fo:table-cell padding="2pt">
                  <fo:block/>
                </fo:table-cell>
                <fo:table-cell padding="2pt">
                  <fo:block>Aktenproduzent</fo:block>
                </fo:table-cell>
                <fo:table-cell padding="2pt">
                  <fo:block>Archiv</fo:block>
                </fo:table-cell>
              </fo:table-row>
            </fo:table-header>
            <fo:table-body>
              <fo:table-row>
                <fo:table-cell padding="2pt">
                  <fo:block>Organisation</fo:block>
                </fo:table-cell>
                <fo:table-cell padding="2pt">
                  <xsl:for-each-group select="submAgr/producer/contact" group-by="organisation">
                    <fo:block>
                      <xsl:value-of select="organisation"/>
                    </fo:block>
                  </xsl:for-each-group>
                </fo:table-cell>
                <fo:table-cell padding="2pt">
                  <fo:block>
                    <xsl:value-of select="submAgr/archive/contact/organisation"/>
                  </fo:block>
                </fo:table-cell>
              </fo:table-row>
              <fo:table-row>
                <fo:table-cell padding="2pt">
                  <fo:block>Abteilung</fo:block>
                </fo:table-cell>
                <fo:table-cell padding="2pt">
                  <xsl:for-each-group select="submAgr/producer/contact" group-by="shortname">
                    <fo:block>
                      <xsl:value-of select="concat(departement, ' (',shortname,')')"/>
                    </fo:block>
                  </xsl:for-each-group>
                </fo:table-cell>
                <fo:table-cell padding="2pt">
                  <fo:block><xsl:value-of select="submAgr/archive/contact/departement"/>
                      (<xsl:value-of select="submAgr/archive/contact/shortname"/>)</fo:block>
                </fo:table-cell>
              </fo:table-row>
              <xsl:if test="not(empty(submAgr/archivecontact/person))">
                <fo:table-row>
                  <fo:table-cell padding="2pt">
                    <fo:block>Person</fo:block>
                  </fo:table-cell>
                  <fo:table-cell padding="2pt">
                    <xsl:for-each-group select="submAgr/producer/contact" group-by="person">
                      <fo:block>
                        <xsl:value-of select="person"/>
                      </fo:block>
                    </xsl:for-each-group>
                  </fo:table-cell>
                  <fo:table-cell padding="2pt">
                    <fo:block>
                      <xsl:value-of select="submAgr/archive/contact/person"/>
                    </fo:block>
                  </fo:table-cell>
                </fo:table-row>
              </xsl:if>
              <fo:table-row>
                <fo:table-cell padding="2pt">
                  <fo:block>Telefon</fo:block>
                </fo:table-cell>
                <fo:table-cell padding="2pt">
                  <fo:block>
                    <xsl:for-each-group select="submAgr/producer/contact" group-by="phone">
                      <fo:block>
                        <xsl:value-of select="phone"/>
                      </fo:block>
                    </xsl:for-each-group>
                  </fo:block>
                </fo:table-cell>
                <fo:table-cell padding="2pt">
                  <fo:block>
                    <xsl:value-of select="submAgr/archive/contact/phone"/>
                  </fo:block>
                </fo:table-cell>
              </fo:table-row>
              <fo:table-row>
                <fo:table-cell padding="2pt">
                  <fo:block>Mail</fo:block>
                </fo:table-cell>
                <fo:table-cell padding="2pt">
                  <fo:block>
                    <xsl:for-each-group select="submAgr/producer/contact" group-by="mail">
                      <fo:block>
                        <xsl:value-of select="mail"/>
                      </fo:block>
                    </xsl:for-each-group>
                  </fo:block>
                </fo:table-cell>
                <fo:table-cell padding="2pt">
                  <fo:block>
                    <xsl:value-of select="submAgr/archive/contact/mail"/>
                  </fo:block>
                </fo:table-cell>
              </fo:table-row>
            </fo:table-body>
          </fo:table>
          <fo:block-container>
            <fo:block font-weight="bold" font-size="12pt" space-before.optimum="12pt"
              space-after.conditionality="discard" space-after="6pt">Bestandesaufnahme</fo:block>
            <xsl:if test="not(empty(submAgr/surveyReport/background))">
              <fo:block font-weight="bold" space-before.optimum="12pt"
                space-after.conditionality="discard" space-after="6pt">Hintergrund</fo:block>
              <xsl:for-each select="submAgr/surveyReport/background/*">
                <xsl:apply-templates/>
              </xsl:for-each>
            </xsl:if>
            <fo:block font-weight="bold" space-before.optimum="12pt"
              space-after.conditionality="discard" space-after="6pt">Daten</fo:block>
            <fo:block font-style="italic" space-before.optimum="6pt">Generelle Beschreibung</fo:block>
            <fo:block>
              <xsl:for-each select="submAgr/surveyReport/records/generalDescription">
                <xsl:apply-templates/>
              </xsl:for-each>
            </fo:block>
            <fo:block font-style="italic" space-before.optimum="6pt">Erstellung</fo:block>
            <fo:block>
              <xsl:for-each select="submAgr/surveyReport/records/creation">
                <xsl:apply-templates/>
              </xsl:for-each>
            </fo:block>
            <xsl:if test="not(empty(submAgr/surveyReport/records/functions))">
              <fo:block font-style="italic" space-before.optimum="6pt">Funktion(en)</fo:block>
              <fo:block>
                <xsl:for-each select="submAgr/surveyReport/records/functions">
                  <xsl:apply-templates/>
                </xsl:for-each>
              </fo:block>
            </xsl:if>
            <xsl:if test="not(empty(submAgr/surveyReport/records/copyright))">
              <fo:block font-style="italic" space-before.optimum="6pt">Urheberrecht</fo:block>
              <fo:block>
                <xsl:for-each select="submAgr/surveyReport/records/copyright">
                  <xsl:apply-templates/>
                </xsl:for-each>
              </fo:block>
            </xsl:if>
            <xsl:if test="not(empty(submAgr/surveyReport/records/recordsSurveyed))">
              <fo:block font-style="italic" space-before.optimum="6pt">Berücksichtigte Daten</fo:block>
              <fo:block>
                <xsl:for-each select="submAgr/surveyReport/records/recordsSurveyed">
                  <xsl:apply-templates/>
                </xsl:for-each>
              </fo:block>
            </xsl:if>
            <xsl:if test="not(empty(submAgr/surveyReport/evaluationRMS))">
              <fo:block font-weight="bold" space-before.optimum="12pt"
                space-after.conditionality="discard" space-after="6pt">Evaluation des Systems zur
                Datenhaltung</fo:block>
              <fo:block>
                <xsl:for-each select="submAgr/surveyReport/evaluationRMS">
                  <xsl:apply-templates/>
                </xsl:for-each>
              </fo:block>
            </xsl:if>
            <xsl:if test="not(empty(submAgr/surveyReport/evaluationAuthenticity))">
              <fo:block font-weight="bold" space-before.optimum="12pt"
                space-after.conditionality="discard" space-after="6pt">Evaluation der Authentizität</fo:block>
              <fo:block>
                <xsl:for-each select="submAgr/surveyReport/evaluationAuthenticity">
                  <xsl:apply-templates/>
                </xsl:for-each>
              </fo:block>
            </xsl:if>
            <fo:block font-weight="bold" space-before.optimum="12pt"
              space-after.conditionality="discard" space-after="6pt">Bewertungsentscheid</fo:block>
            <fo:block>
              <xsl:for-each select="submAgr/surveyReport/appraisalDecision">
                <xsl:apply-templates/>
              </xsl:for-each>
            </fo:block>
          </fo:block-container>
          <fo:block-container break-before="page">
            <fo:block font-weight="bold" font-size="12pt" space-before.optimum="12pt"
              space-after.conditionality="discard" space-after="6pt">Ablieferungen</fo:block>
            <xsl:for-each select="submAgr/dataSubmissionSession">
              <fo:block-container space-before="18pt" keep-together="always">
                <fo:block font-weight="bold" space-after="6pt"><xsl:value-of select="title"/>
                    (<xsl:value-of select="@dssID"/>)</fo:block>
                <fo:table table-layout="fixed" width="16cm" space-after="6pt">
                  <fo:table-column column-width="4cm" border-end-color="black"
                    border-end-style="solid" border-end-width="1pt"/>
                  <fo:table-column column-width="12cm"/>
                  <fo:table-body>
                    <fo:table-row border-bottom="1pt solid black">
                      <fo:table-cell padding="2pt">
                        <fo:block font-style="italic">Zeitplan</fo:block>
                      </fo:table-cell>
                      <fo:table-cell padding="2pt">
                        <fo:table table-layout="fixed" width="12cm">
                          <fo:table-column column-width="3cm"/>
                          <fo:table-column column-width="9cm"/>
                          <fo:table-body>
                            <fo:table-row>
                              <xsl:choose>
                                <xsl:when test="schedule/*[name()='variable']">
                                  <fo:table-cell>
                                    <fo:block>Variabel</fo:block>
                                  </fo:table-cell>
                                  <fo:table-cell>
                                    <fo:block>
                                      <xsl:value-of select="schedule/variable"/>
                                      <xsl:if test="not(empty(schedule/note))">
                                        <xsl:value-of select="concat(' (', schedule/note, ')')"/>
                                      </xsl:if>
                                    </fo:block>
                                  </fo:table-cell>
                                </xsl:when>
                                <xsl:otherwise>
                                  <fo:table-cell>
                                    <fo:block>
                                      <xsl:value-of
                                        select="format-date(schedule/offset, '[D01].[M01].[Y0001]')"
                                      />
                                    </fo:block>
                                  </fo:table-cell>
                                  <fo:table-cell>
                                    <xsl:choose>
                                      <xsl:when test="schedule/frequency/*[name()='unique']">
                                        <fo:block>einmalig </fo:block>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <fo:block>Rhythmus: <xsl:value-of
                                            select="concat(schedule/frequency/count, ' ', schedule/frequency/unit)"
                                          />
                                        </fo:block>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </fo:table-cell>
                                </xsl:otherwise>
                              </xsl:choose>
                            </fo:table-row>
                          </fo:table-body>
                        </fo:table>
                      </fo:table-cell>
                    </fo:table-row>
                    <xsl:if test="not(empty(transfer))">
                      <fo:table-row border-bottom="1pt solid black">
                        <fo:table-cell padding="2pt">
                          <fo:block font-style="italic">Übermittlung</fo:block>
                        </fo:table-cell>
                        <fo:table-cell padding="2pt">
                          <fo:table table-layout="fixed" width="12cm">
                            <fo:table-column column-width="3cm"/>
                            <fo:table-column column-width="9cm"/>
                            <fo:table-body>
                              <fo:table-row>
                                <fo:table-cell>
                                  <fo:block>Modus:</fo:block>
                                </fo:table-cell>
                                <fo:table-cell>
                                  <fo:block>
                                    <xsl:value-of select="transfer/mode"/>
                                  </fo:block>
                                </fo:table-cell>
                              </fo:table-row>
                              <fo:table-row>
                                <fo:table-cell>
                                  <fo:block>Initiator:</fo:block>
                                </fo:table-cell>
                                <fo:table-cell>
                                  <fo:block>
                                    <xsl:variable name="initiator" select="transfer/@initiator"/>
                                    <xsl:value-of
                                      select="/submAgr/*/contact[@contactID=$initiator]/organisation"
                                      />/<xsl:value-of
                                      select="/submAgr/*/contact[@contactID=$initiator]/departement"
                                    />
                                  </fo:block>
                                </fo:table-cell>
                              </fo:table-row>
                              <fo:table-row>
                                <fo:table-cell>
                                  <fo:block>Verschlüsselung:</fo:block>
                                </fo:table-cell>
                                <fo:table-cell>
                                  <fo:block>
                                    <xsl:choose>
                                      <xsl:when test="transfer/@secure='true'">ja</xsl:when>
                                      <xsl:otherwise>nein</xsl:otherwise>
                                    </xsl:choose>
                                  </fo:block>
                                </fo:table-cell>
                              </fo:table-row>
                              <xsl:if test="not(empty(transfer/instruction))">
                                <fo:table-row>
                                  <fo:table-cell>
                                    <fo:block>Anleitung:</fo:block>
                                  </fo:table-cell>
                                  <fo:table-cell>
                                    <xsl:for-each select="transfer/instruction">
                                      <xsl:apply-templates/>
                                    </xsl:for-each>
                                  </fo:table-cell>
                                </fo:table-row>
                              </xsl:if>
                            </fo:table-body>
                          </fo:table>
                        </fo:table-cell>
                      </fo:table-row>
                    </xsl:if>
                    <xsl:if test="not(empty(contentInformation))">
                      <fo:table-row border-bottom="1pt solid black">
                        <fo:table-cell padding="2pt">
                          <fo:block font-style="italic">Inhalt</fo:block>
                        </fo:table-cell>
                        <fo:table-cell padding="2pt">
                          <fo:block>
                            <xsl:value-of select="contentInformation"/>
                          </fo:block>
                        </fo:table-cell>
                      </fo:table-row>
                    </xsl:if>
                    <fo:table-row border-bottom="1pt solid black">
                      <fo:table-cell padding="2pt">
                        <fo:block font-style="italic">Datentypen</fo:block>
                      </fo:table-cell>
                      <fo:table-cell padding="2pt">
                        <fo:block>
                          <xsl:value-of select="recordTypes"/>
                        </fo:block>
                      </fo:table-cell>
                    </fo:table-row>
                    <fo:table-row border-bottom="1pt solid black">
                      <fo:table-cell padding="2pt">
                        <fo:block font-style="italic">Dateiformate</fo:block>
                      </fo:table-cell>
                      <fo:table-cell padding="2pt">
                        <fo:block>
                          <xsl:for-each select="fileFormats/*">
                            <xsl:value-of select="."/>
                            <xsl:if test="position() != last()">
                              <xsl:text>, </xsl:text>
                            </xsl:if>
                          </xsl:for-each>
                        </fo:block>
                      </fo:table-cell>
                    </fo:table-row>
                    <xsl:if test="not(empty(fileSize))">
                      <fo:table-row border-bottom="1pt solid black">
                        <fo:table-cell padding="2pt">
                          <fo:block font-style="italic">Dateigrösse</fo:block>
                        </fo:table-cell>
                        <fo:table-cell padding="2pt">
                          <fo:block>
                            <xsl:choose>
                              <xsl:when test="fileSize/amount[number()=0]">keine Angabe</xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of
                                  select="concat(fileSize/amount, ' ', fileSize/@measure)"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </fo:block>
                        </fo:table-cell>
                      </fo:table-row>
                    </xsl:if>
                    <xsl:if test="not(empty(fileCount))">
                      <fo:table-row border-bottom="1pt solid black">
                        <fo:table-cell padding="2pt">
                          <fo:block font-style="italic">Ungefähre Anzahl Dateien</fo:block>
                        </fo:table-cell>
                        <fo:table-cell padding="2pt">
                          <fo:block>
                            <xsl:choose>
                              <xsl:when test="fileCount[number()=0]">keine Angabe</xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="fileCount"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </fo:block>
                        </fo:table-cell>
                      </fo:table-row>
                    </xsl:if>
                    <xsl:if test="not(empty(namingConvention))">
                      <fo:table-row border-bottom="1pt solid black">
                        <fo:table-cell padding="2pt">
                          <fo:block font-style="italic">Namenskonventionen</fo:block>
                        </fo:table-cell>
                        <fo:table-cell padding="2pt">
                          <fo:block>
                            <xsl:value-of select="namingConventions"/>
                          </fo:block>
                        </fo:table-cell>
                      </fo:table-row>
                    </xsl:if>
                    <xsl:if test="not(empty(existingIdentifiers))">
                      <fo:table-row border-bottom="1pt solid black">
                        <fo:table-cell padding="2pt">
                          <fo:block font-style="italic">Bestehende Identifikatoren</fo:block>
                        </fo:table-cell>
                        <fo:table-cell padding="2pt">
                          <fo:block>
                            <xsl:value-of select="existingIdentifiers"/>
                          </fo:block>
                        </fo:table-cell>
                      </fo:table-row>
                    </xsl:if>
                    <xsl:if test="not(empty(additionalMetadata))">
                      <fo:table-row border-bottom="1pt solid black">
                        <fo:table-cell padding="2pt">
                          <fo:block font-style="italic">Zusätzliche Metadaten</fo:block>
                        </fo:table-cell>
                        <fo:table-cell padding="2pt">
                          <fo:block>
                            <xsl:value-of select="additionalMetadata"/>
                          </fo:block>
                        </fo:table-cell>
                      </fo:table-row>
                    </xsl:if>
                    <xsl:if test="not(empty(responsibilities))">
                      <fo:table-row border-bottom="1pt solid black">
                        <fo:table-cell padding="2pt">
                          <fo:block font-style="italic">Verantwortlichkeiten</fo:block>
                        </fo:table-cell>
                        <fo:table-cell padding="2pt">
                          <fo:block>
                            <xsl:value-of select="responsibilities"/>
                          </fo:block>
                        </fo:table-cell>
                      </fo:table-row>
                    </xsl:if>
                    <xsl:if test="not(empty(packaging))">
                      <fo:table-row border-bottom="1pt solid black">
                        <fo:table-cell padding="2pt">
                          <fo:block font-style="italic">Paketbildung</fo:block>
                        </fo:table-cell>
                        <fo:table-cell padding="2pt">
                          <fo:block>
                            <xsl:value-of select="packaging"/>
                          </fo:block>
                        </fo:table-cell>
                      </fo:table-row>
                    </xsl:if>
                    <xsl:if test="not(empty(access))">
                      <fo:table-row border-bottom="1pt solid black">
                        <fo:table-cell padding="2pt">
                          <fo:block font-style="italic">Zugang</fo:block>
                        </fo:table-cell>
                        <fo:table-cell padding="2pt">
                          <fo:block>
                            <xsl:value-of select="access"/>
                          </fo:block>
                        </fo:table-cell>
                      </fo:table-row>
                    </xsl:if>
                    <xsl:if test="not(empty(note))">
                      <fo:table-row>
                        <fo:table-cell padding="2pt">
                          <fo:block font-style="italic">Notizen</fo:block>
                        </fo:table-cell>
                        <fo:table-cell padding="2pt">
                          <fo:block>
                            <xsl:value-of select="note"/>
                          </fo:block>
                        </fo:table-cell>
                      </fo:table-row>
                    </xsl:if>
                  </fo:table-body>
                </fo:table>
              </fo:block-container>
            </xsl:for-each>
          </fo:block-container>
          <fo:block-container space-before="4cm">
            <fo:table table-layout="fixed" width="16cm" space-after="6pt">
              <fo:table-column column-width="7.5cm"/>
              <fo:table-column column-width="1cm"/>
              <fo:table-column column-width="7.5cm"/>
              <fo:table-body>
                <fo:table-row>
                  <fo:table-cell border-top-width="1pt" border-top-color="black"
                    border-top-style="solid" padding-top="2pt">
                    <fo:block>
                      <xsl:value-of select="submAgr/producer/contact/departement"/>
                    </fo:block>
                  </fo:table-cell>
                  <fo:table-cell>
                    <fo:block/>
                  </fo:table-cell>
                  <fo:table-cell border-top-width="1pt" border-top-color="black"
                    border-top-style="solid" padding-top="2pt">
                    <fo:block>
                      <xsl:value-of select="submAgr/archive/contact/departement"/>
                    </fo:block>
                  </fo:table-cell>
                </fo:table-row>
              </fo:table-body>
            </fo:table>
          </fo:block-container>
        </fo:flow>
      </fo:page-sequence>
    </fo:root>
  </xsl:template>
  <xsl:template match="p">
    <fo:block>
      <xsl:value-of select="."/>
    </fo:block>
  </xsl:template>
  <xsl:template match="head">
    <fo:block font-style="bold">
      <xsl:value-of select="."/>
    </fo:block>
  </xsl:template>
</xsl:stylesheet>
